/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ReifiedTypeParameterAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkTypeParameterDescriptorsAreNotReified", "typeParameterDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
@SourceDebugExtension(value={"SMAP\nReifiedTypeParameterAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReifiedTypeParameterAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ReifiedTypeParameterAnnotationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n777#2:61\n873#2,2:62\n*S KotlinDebug\n*F\n+ 1 ReifiedTypeParameterAnnotationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ReifiedTypeParameterAnnotationChecker\n*L\n48#1:61\n48#1:62,2\n*E\n"})
public final class ReifiedTypeParameterAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (descriptor instanceof CallableDescriptor && !InlineUtil.isInline(descriptor) && !InlineUtil.isPropertyWithAllAccessorsAreInline(descriptor)) {
            List<TypeParameterDescriptor> list = ((CallableDescriptor)descriptor).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
            this.checkTypeParameterDescriptorsAreNotReified(list, context2.getTrace());
        }
        if (descriptor instanceof ClassDescriptor) {
            List<TypeParameterDescriptor> list = ((ClassDescriptor)descriptor).getDeclaredTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getDeclaredTypeParameters(...)");
            this.checkTypeParameterDescriptorsAreNotReified(list, context2.getTrace());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParameterDescriptorsAreNotReified(List<? extends TypeParameterDescriptor> typeParameterDescriptors, DiagnosticSink diagnosticHolder) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = typeParameterDescriptors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
            boolean bl = false;
            if (!it.isReified()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (TypeParameterDescriptor reifiedTypeParameterDescriptor : (List)destination$iv$iv) {
            PsiElement typeParameterDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(reifiedTypeParameterDescriptor);
            if (!(typeParameterDeclaration instanceof KtTypeParameter)) {
                throw new AssertionError((Object)"KtTypeParameter expected");
            }
            KtModifierList ktModifierList = ((KtTypeParameter)typeParameterDeclaration).getModifierList();
            Intrinsics.checkNotNull(ktModifierList);
            PsiElement psiElement = ktModifierList.getModifier(KtTokens.REIFIED_KEYWORD);
            Intrinsics.checkNotNull(psiElement);
            diagnosticHolder.report(Errors.REIFIED_TYPE_PARAMETER_NO_INLINE.on(psiElement));
        }
    }
}

