/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationCacheOwnerNormalizer;
import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class AnnotationUtil {
    private static final ParameterizedCachedValueProvider<Map<Collection<String>, List<PsiAnnotation>>, PsiModifierListOwner> NON_CODE_ANNOTATIONS_PROVIDER = listOwner -> {
        ConcurrentMap<Collection, List> value2 = ConcurrentFactoryMap.createMap(annotationNames1 -> {
            PsiUtilCore.ensureValid(listOwner);
            Project project = listOwner.getProject();
            SmartList<PsiAnnotation> annotations2 = null;
            ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance(project);
            for (String annotationName : annotationNames1) {
                List<PsiAnnotation> externalAnnotations = externalAnnotationsManager.findExternalAnnotations((PsiModifierListOwner)listOwner, annotationName);
                if (externalAnnotations.isEmpty()) continue;
                if (annotations2 == null) {
                    annotations2 = new SmartList<PsiAnnotation>();
                }
                annotations2.addAll(externalAnnotations);
            }
            InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
            for (String annotationName : annotationNames1) {
                PsiAnnotation annotation = inferredAnnotationsManager.findInferredAnnotation((PsiModifierListOwner)listOwner, annotationName);
                if (annotation == null) continue;
                if (annotations2 == null) {
                    annotations2 = new SmartList();
                }
                annotations2.add(annotation);
            }
            return annotations2;
        });
        return CachedValueProvider.Result.create(value2, PsiModificationTracker.MODIFICATION_COUNT);
    };
    private static final Key<ParameterizedCachedValue<Map<Collection<String>, List<PsiAnnotation>>, PsiModifierListOwner>> NON_CODE_ANNOTATIONS_KEY = Key.create("NON_CODE_ANNOTATIONS");
    private static final String[] SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(0);
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(1);
        }
        if (annotationNames.length == 0) {
            return null;
        }
        HashSet<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : ContainerUtil.newHashSet(annotationNames);
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(4);
        }
        if (listOwner == null) {
            return null;
        }
        List<PsiAnnotation> result2 = AnnotationUtil.findAllAnnotations(listOwner, annotationNames, skipExternal);
        return result2.isEmpty() ? null : result2.get(0);
    }

    @NotNull
    public static List<PsiAnnotation> findAllAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(5);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(6);
        }
        List<PsiAnnotation> ownAnnotations = AnnotationUtil.findOwnAnnotations(listOwner, annotationNames);
        List<PsiAnnotation> nonCodeAnnotations = skipExternal ? null : AnnotationUtil.findNonCodeAnnotations(listOwner, annotationNames);
        SmartList annotations2 = null;
        if (ownAnnotations != null || nonCodeAnnotations != null) {
            annotations2 = new SmartList();
            if (ownAnnotations != null) {
                annotations2.addAll(ownAnnotations);
            }
            if (nonCodeAnnotations != null) {
                annotations2.addAll(nonCodeAnnotations);
            }
        }
        List<PsiAnnotation> list = annotations2 == null ? Collections.emptyList() : annotations2;
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private static List<PsiAnnotation> findOwnAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Iterable<String> annotationNames) {
        PsiModifierList list;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(8);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(9);
        }
        if ((list = listOwner.getModifierList()) == null) {
            return null;
        }
        SmartList<PsiAnnotation> result2 = null;
        for (PsiAnnotation annotation : list.getAnnotations()) {
            if (!ContainerUtil.exists(annotationNames, annotation::hasQualifiedName) || !AnnotationUtil.isApplicableToDeclaration(annotation, list)) continue;
            if (result2 == null) {
                result2 = new SmartList<PsiAnnotation>();
            }
            result2.add(annotation);
        }
        return result2;
    }

    private static boolean isApplicableToDeclaration(PsiAnnotation annotation, PsiModifierList list) {
        PsiAnnotation.TargetType[] allTargets = AnnotationTargetUtil.getTargetsForLocation(list);
        if (allTargets.length == 0) {
            return true;
        }
        PsiAnnotation.TargetType[] nonTypeUse = (PsiAnnotation.TargetType[])Stream.of(allTargets).filter(t2 -> t2 != PsiAnnotation.TargetType.TYPE_USE).toArray(PsiAnnotation.TargetType[]::new);
        return AnnotationTargetUtil.findAnnotationTarget(annotation, nonTypeUse) != null;
    }

    @Nullable
    private static List<PsiAnnotation> findNonCodeAnnotations(@NotNull PsiModifierListOwner element, @NotNull Collection<String> annotationNames) {
        if (element == null) {
            AnnotationUtil.$$$reportNull$$$0(10);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(11);
        }
        if (element instanceof PsiLocalVariable) {
            return null;
        }
        PsiModifierListOwner listOwner = AnnotationCacheOwnerNormalizer.normalize(element);
        Map<Collection<String>, List<PsiAnnotation>> map = CachedValuesManager.getManager(element.getProject()).getParameterizedCachedValue(listOwner, NON_CODE_ANNOTATIONS_KEY, NON_CODE_ANNOTATIONS_PROVIDER, false, listOwner);
        return map.get(annotationNames);
    }

    @NotNull
    public static <T extends PsiModifierListOwner> List<T> getSuperAnnotationOwners(@NotNull T element) {
        if (element == null) {
            AnnotationUtil.$$$reportNull$$$0(16);
        }
        PsiModifierListOwner listOwner = AnnotationCacheOwnerNormalizer.normalize(element);
        List list = (List)CachedValuesManager.getCachedValue(listOwner, () -> {
            List<Object> list;
            LinkedHashSet result2 = new LinkedHashSet();
            if (listOwner instanceof PsiMethod) {
                if (!listOwner.hasModifierProperty("static")) {
                    AnnotationUtil.collectSuperMethods(result2, ((PsiMethod)listOwner).getHierarchicalMethodSignature(), listOwner, JavaPsiFacade.getInstance(listOwner.getProject()).getResolveHelper());
                }
            } else if (listOwner instanceof PsiClass) {
                InheritanceUtil.processSupers((PsiClass)listOwner, false, Processors.cancelableCollectProcessor(result2));
            } else if (listOwner instanceof PsiParameter) {
                AnnotationUtil.collectSuperParameters(result2, (PsiParameter)listOwner);
            }
            if (result2.isEmpty()) {
                list = Collections.emptyList();
            } else {
                PsiModifierListOwner[] array = result2.toArray(new PsiModifierListOwner[0]);
                list = Arrays.asList(array);
            }
            return CachedValueProvider.Result.create(list, PsiModificationTracker.MODIFICATION_COUNT);
        });
        if (list == null) {
            AnnotationUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    static AnnotationAndOwner findAnnotationAndOwnerInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames, boolean skipExternal) {
        PsiAnnotation directAnnotation;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(22);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(23);
        }
        if ((directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames, skipExternal)) != null) {
            return new AnnotationAndOwner(listOwner, directAnnotation);
        }
        for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners(listOwner)) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation(superOwner, annotationNames, skipExternal);
            if (annotation == null) continue;
            return new AnnotationAndOwner(superOwner, annotation);
        }
        return null;
    }

    private static void collectSuperParameters(@NotNull Set<? super PsiModifierListOwner> result2, @NotNull PsiParameter parameter) {
        block7: {
            PsiElement scope2;
            Consumer<PsiMethod> forEachSuperMethod;
            block6: {
                PsiElement parent2;
                if (result2 == null) {
                    AnnotationUtil.$$$reportNull$$$0(24);
                }
                if (parameter == null) {
                    AnnotationUtil.$$$reportNull$$$0(25);
                }
                if (!((parent2 = parameter.getParent()) instanceof PsiParameterList)) {
                    return;
                }
                int index = ((PsiParameterList)parent2).getParameterIndex(parameter);
                forEachSuperMethod = method -> {
                    PsiParameter[] superParameters = method.getParameterList().getParameters();
                    if (index < superParameters.length) {
                        result2.add(superParameters[index]);
                    }
                };
                scope2 = parent2.getParent();
                if (!(scope2 instanceof PsiLambdaExpression)) break block6;
                PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)scope2).getFunctionalInterfaceType());
                if (method2 == null) break block7;
                forEachSuperMethod.consume(method2);
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners(method2)) {
                    forEachSuperMethod.consume(superMethod);
                }
                break block7;
            }
            if (scope2 instanceof PsiMethod) {
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners((PsiMethod)scope2)) {
                    forEachSuperMethod.consume(superMethod);
                }
            }
        }
    }

    private static void collectSuperMethods(@NotNull Set<? super PsiModifierListOwner> result2, @NotNull HierarchicalMethodSignature signature, @NotNull PsiElement place, @NotNull PsiResolveHelper resolveHelper) {
        if (result2 == null) {
            AnnotationUtil.$$$reportNull$$$0(26);
        }
        if (signature == null) {
            AnnotationUtil.$$$reportNull$$$0(27);
        }
        if (place == null) {
            AnnotationUtil.$$$reportNull$$$0(28);
        }
        if (resolveHelper == null) {
            AnnotationUtil.$$$reportNull$$$0(29);
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null) || !result2.add(superMethod)) continue;
            AnnotationUtil.collectSuperMethods(result2, superSignature, place, resolveHelper);
        }
    }

    public static boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(45);
        }
        return InferredAnnotationsManager.getInstance(annotation.getProject()).isInferredAnnotation(annotation);
    }

    public static boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(46);
        }
        return ExternalAnnotationsManager.getInstance(annotation.getProject()).isExternalAnnotation(annotation);
    }

    @Contract(pure=true)
    @Nullable
    public static PsiNameValuePair findDeclaredAttribute(@NotNull PsiAnnotation annotation, @Nullable(value="null means 'value'") @NonNls @Nullable(value="null means 'value'") @NonNls String attributeName) {
        if (annotation == null) {
            AnnotationUtil.$$$reportNull$$$0(54);
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : annotation.getParameterList().getAttributes()) {
            String name2 = attribute.getName();
            if (!Objects.equals(name2, attributeName) && (attributeName != null || !"value".equals(name2))) continue;
            return attribute;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 43: 
            case 60: 
            case 68: 
            case 69: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 43: 
            case 60: 
            case 68: 
            case 69: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNames";
                break;
            }
            case 5: 
            case 8: 
            case 18: 
            case 20: 
            case 22: 
            case 30: 
            case 32: 
            case 34: 
            case 52: 
            case 62: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 43: 
            case 60: 
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 10: 
            case 16: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 31: 
            case 39: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqn";
                break;
            }
            case 35: 
            case 38: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 45: 
            case 46: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMap";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations1";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations2";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAnnotations";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotations";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperAnnotationOwners";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAnnotationMap";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayAttributeValues";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAllAnnotations";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 43: 
            case 60: 
            case 68: 
            case 69: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findOwnAnnotations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findNonCodeAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSuperAnnotationOwners";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInHierarchy";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationAndOwnerInHierarchy";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperParameters";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperMethods";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatingApplicable";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotatedUsingPatterns";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMethod";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isInsideAnnotation";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isInferredAnnotation";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 47: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getStringAttributeValue";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanAttributeValue";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getLongAttributeValue";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredStringAttributeValue";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttribute";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "fillValueMap";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "buildAnnotationMap";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isJetbrainsAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 43: 
            case 60: 
            case 68: 
            case 69: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class AnnotationAndOwner {
        @NotNull
        final PsiModifierListOwner owner;
        @NotNull
        final PsiAnnotation annotation;

        AnnotationAndOwner(@NotNull PsiModifierListOwner owner, @NotNull PsiAnnotation annotation) {
            if (owner == null) {
                AnnotationAndOwner.$$$reportNull$$$0(0);
            }
            if (annotation == null) {
                AnnotationAndOwner.$$$reportNull$$$0(1);
            }
            this.owner = owner;
            this.annotation = annotation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "annotation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/AnnotationUtil$AnnotationAndOwner";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

